% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real_time_00_mfd.R
\name{get_mfd_df_real_time}
\alias{get_mfd_df_real_time}
\title{Get a list of functional data objects each evolving up to
an intermediate domain point.}
\usage{
get_mfd_df_real_time(
  dt,
  domain,
  arg,
  id,
  variables,
  n_basis = 30,
  lambda = NULL,
  lambda_grid = 10^seq(-10, 1, length.out = 10),
  k_seq = seq(from = 0.25, to = 1, length.out = 10),
  ncores = 1
)
}
\arguments{
\item{dt}{See \code{\link{get_mfd_df}}.}

\item{domain}{See \code{\link{get_mfd_df}}.}

\item{arg}{See \code{\link{get_mfd_df}}.}

\item{id}{See \code{\link{get_mfd_df}}.}

\item{variables}{See \code{\link{get_mfd_df}}.}

\item{n_basis}{See \code{\link{get_mfd_df}}.}

\item{lambda}{See \code{\link{get_mfd_df}}.}

\item{lambda_grid}{See \code{\link{get_mfd_df}}.}

\item{k_seq}{A vector of values between 0 and 1, containing the domain points
over which functional data are to be evaluated in real time.
If the domain is the interval (a,b), for each instant k in the sequence,
functions are evaluated in (a,k(b-a)).}

\item{ncores}{If you want parallelization, give the number of cores/threads
to be used when creating mfd objects separately for different instants.}
}
\value{
A list of \code{mfd} objects as produced by
\code{\link{get_mfd_df}},
corresponding to a given instant.
}
\description{
This function produces a list functional data objects,
each evolving up to an intermediate domain point, that can be used to
estimate models that allow real-time predictions of incomplete functions,
from the current functional domain up to the end of the observation,
and to build control charts for real-time  monitoring.

It calls the function \code{\link{get_mfd_df}} for each domain point.
}
\examples{
library(funcharts)

x <- seq(1, 10, length = 25)
y11 <- cos(x)
y21 <- cos(2 * x)
y12 <- sin(x)
y22 <- sin(2 * x)
df <- data.frame(id = factor(rep(1:2, each = length(x))),
                 x = rep(x, times = 2),
                 y1 = c(y11, y21),
                 y2 = c(y12, y22))

mfdobj_list <- get_mfd_df_real_time(dt = df,
                                    domain = c(1, 10),
                                    arg = "x",
                                    id = "id",
                                    variables = c("y1", "y2"),
                                    lambda = 1e-2)

}
\seealso{
\code{\link{get_mfd_df}}
}
