% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real_time_00_mfd.R
\name{get_mfd_array_real_time}
\alias{get_mfd_array_real_time}
\title{Get a list of functional data objects each evolving up to
an intermediate domain point.}
\usage{
get_mfd_array_real_time(
  data_array,
  grid = NULL,
  n_basis = 30,
  lambda = NULL,
  lambda_grid = 10^seq(-10, 1, length.out = 10),
  k_seq = seq(from = 0.25, to = 1, length.out = 10),
  ncores = 1
)
}
\arguments{
\item{data_array}{See \code{\link{get_mfd_array}}.}

\item{grid}{See \code{\link{get_mfd_array}}.}

\item{n_basis}{See \code{\link{get_mfd_array}}.}

\item{lambda}{See \code{\link{get_mfd_array}}.}

\item{lambda_grid}{See \code{\link{get_mfd_array}}.}

\item{k_seq}{A vector of values between 0 and 1, containing the domain points
over which functional data are to be evaluated in real time.
If the domain is the interval (a,b), for each instant k in the sequence,
functions are evaluated in (a,k(b-a)).}

\item{ncores}{If you want parallelization, give the number of cores/threads
to be used when creating mfd objects separately for different instants.}
}
\value{
A list of \code{mfd} objects as produced by
\code{\link{get_mfd_array}}.
}
\description{
This function produces a list functional data objects,
each evolving up to an intermediate domain point, that can be used to
estimate models that allow real-time predictions of incomplete functions,
from the current functional domain up to the end of the observation,
and to build control charts for real-time  monitoring.

It calls the function \code{\link{get_mfd_array}} for each domain point.
}
\examples{
library(funcharts)
data("CanadianWeather")
fdobj <- get_mfd_array_real_time(CanadianWeather$dailyAv[, 1:5, 1:2],
                                 lambda = 1e-2)

}
\seealso{
\code{\link{get_mfd_array}}
}
