% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ft_serialize.R
\name{ft_serialize}
\alias{ft_serialize}
\alias{ft_get_keys}
\title{Serialize raw text to other formats, including to disk}
\usage{
ft_serialize(x, to = "xml", from = NULL, ...)

ft_get_keys(x)
}
\arguments{
\item{x}{Input object, output from a call to \code{ft_get}. Required.}

\item{to}{(character) Format to serialize to. One of list,
xml, or json. Required. Output to xml returns object of
class XMLInternalDocument.}

\item{from}{(character) Format \code{x} is currently in. Function attempts
to use metadata provided, or guess from data itself. Optional.
CURRENTLY IGNORED.}

\item{...}{Further args passed on to \code{\link[xml2:read_xml]{xml2::read_xml()}} or
\code{\link[jsonlite:toJSON]{jsonlite::toJSON()}}}
}
\value{
An object of class \code{ft_parsed}
}
\description{
\code{ft_serialize} helps you convert to various data formats. If
your data is in unparsed XML (i.e., character class), you can convert to
parsed XML. If in XML, you can convert to (ugly-ish) JSON, or a list.
}
\examples{
\dontrun{
res <- ft_get('10.7717/peerj.228')

# if articles in xml format, parse the XML
(out <- ft_serialize(ft_collect(res), to='xml'))
out$peerj$data$data[[1]] # the xml

# From XML to JSON
(out <- ft_serialize(ft_collect(res), to='json'))
out$peerj$data$data$`10.7717/peerj.228` # the json
jsonlite::fromJSON(out$peerj$data$data$`10.7717/peerj.228`)

# To a list
out <- ft_serialize(ft_collect(res), to='list')
out$peerj$data$data
out$peerj$data$data[[1]]$body$sec$title
}
}
