% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_boundary.R
\name{get_boundary}
\alias{get_boundary}
\title{Get the agricultural community boundary data}
\usage{
get_boundary(data, year = 2020, quiet = FALSE, to_wgs84 = TRUE)
}
\arguments{
\item{data}{List of \code{\link[sf:sf]{sf::sf()}} objects.}

\item{year}{Year in which the agricultural community boundary data was created.}

\item{quiet}{logical. Suppress information about the data to be read.}

\item{to_wgs84}{logical. Convert JGD2000 to WGS 84.}
}
\value{
A list of \code{\link[sf:sf]{sf::sf()}} objects.
}
\description{
\code{get_boundary()} downloads and reads one or more agricultural community
boundary data provided by the MAFF.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
path <- system.file("extdata", "castle.zip", package = "fude")
d <- read_fude(path)
b <- get_boundary(d)
\dontshow{\}) # examplesIf}
}
