% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readASAdir.R
\name{readASAdir}
\alias{readASAdir}
\title{Read Directory of Accessible Solvent accessibility predicted files (readASAdir)}
\usage{
readASAdir(dirPath)
}
\arguments{
\item{dirPath}{path of the directory which contains all the output files of SPINE-X. Each file belongs to a sequence.}
}
\value{
a list of vectors with all the predicted ASA value for each amino acid. The length of the
list is the number of files(sequences) and the length of each vector is (length of sequence(i))
}
\description{
This function reads a directory that contains the output files of SPINE-X.
It gets the directory path as the input and returns a list of vectors. Each vector includes the ASA predicted value for amino acids of the sequence.
}
\examples{



PredASAdir<-system.file("testForder",package="ftrCOOL")
PredASAdir<-paste0(PredASAdir,"/ASAdir/")
PredVectASA<-readASAdir(PredASAdir)

}
