% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AAKpartComposition.R
\name{AAKpartComposition}
\alias{AAKpartComposition}
\title{Amino Acid to K Part Composition (AAKpartComposition)}
\usage{
AAKpartComposition(seqs, k = 3, normalized = TRUE, label = c())
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{k}{is an integer value. Each sequence should be divided to k partition(s).}

\item{normalized}{is a logical parameter. When it is FALSE, the return value of the function does not change. Otherwise, the return value is normalized using the length of the sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
a feature matrix with k*20 number of columns. The number of rows is equal to the number of
sequences.
}
\description{
In this function, each sequence is divided into k equal partitions.
The length of each part is equal to ceiling(l(lenght of the sequence)/k).
The last part can have a different length containing the residual amino acids.
The amino acid composition is calculated for each part.
}
\note{
Warning: The length of all sequences should be greater than k.
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")
mat<-AAKpartComposition(seqs=filePrs,k=5,normalized=FALSE)

}
