% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openmp.R
\name{threads_fst}
\alias{threads_fst}
\title{Get or set the number of threads used in parallel operations}
\usage{
threads_fst(nr_of_threads = NULL)
}
\arguments{
\item{nr_of_threads}{number of threads to use or \code{NULL} to get the current number of threads used in
multithreaded operations.}
}
\value{
the number of threads (previously) used
}
\description{
For parallel operations, the performance is determined to a great extend by the number of threads
used. More threads will allow the CPU to perform more computational intensive tasks simultaneously,
speeding up the operation. Using more threads also introduces some overhead that will scale with the
number of threads used. Therefore, using the maximum number of available threads is not always the
fastest solution. With \code{threads_fst} the number of threads can be adjusted to the users
specific requirements. As a default, \code{fst} uses a number of threads equal to the number of
logical cores in the system.
}
