% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{fst-package}
\alias{fst}
\alias{fst-package}
\title{Lightning Fast Serialization of Data Frames for R.}
\description{
Multithreaded serialization of compressed data frames using the 'fst' format.
The 'fst' format allows for random access of stored data which can be compressed with the
LZ4 and ZSTD compressors.
}
\details{
The fst package is based on three C++ libraries:
\itemize{
\item \strong{fstlib}: library containing code to write, read and compute on files stored in the \emph{fst} format.
Written and owned by Mark Klik.
\item \strong{LZ4}: library containing code to compress data with the LZ4 compressor. Written and owned
by Yann Collet.
\item \strong{ZSTD}: library containing code to compress data with the ZSTD compressor. Written by
Yann Collet and owned by Facebook, Inc.
}

\strong{\emph{The following copyright notice, list of conditions and disclaimer apply to
the use of the ZSTD library in the fst package:}}

BSD License

For Zstandard software

Copyright (c) 2016-present, Facebook, Inc. All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:
\itemize{
\item Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
\item Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.
\item Neither the name Facebook nor the names of its contributors may be used to
endorse or promote products derived from this software without specific
prior written permission.
}

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

\strong{\emph{The following copyright notice, list of conditions and disclaimer apply to
the use of the LZ4 library in the fst package:}}

LZ4 Library
Copyright (c) 2011-2016, Yann Collet
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:
\itemize{
\item Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
\item Redistributions in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.
}

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://fstpackage.github.io}
  \item Report bugs at \url{https://github.com/fstpackage/fst/issues}
}

}
\author{
\strong{Maintainer}: Mark Klik \email{markklik@gmail.com} [copyright holder]

Other contributors:
\itemize{
  \item Yann Collet (Yann Collet is author of the bundled LZ4 and ZSTD code and copyright holder of LZ4) [contributor, copyright holder]
  \item Facebook, Inc. (Bundled ZSTD code) [copyright holder]
}

}
