% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsl_slicetimer.R
\name{fslslicetimer}
\alias{fslslicetimer}
\alias{fsl_slicetimer}
\title{FSL Slice Timing Correction}
\usage{
fslslicetimer(file, outfile = NULL, retimg = TRUE, reorient = FALSE,
  intern = FALSE, tr = 3, direction = "z", indexing = c("up", "down"),
  acq_order = c("contiguous", "interleaved"), verbose = TRUE, ...)

fsl_slicetimer(..., outfile = tempfile(fileext = ".nii.gz"), retimg = FALSE)
}
\arguments{
\item{file}{(character) image to be manipulated}

\item{outfile}{(character) resultant image name (optional)}

\item{retimg}{(logical) return image of class nifti}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link{readnii}}.}

\item{intern}{(logical) to be passed to \code{\link{system}}}

\item{tr}{(numeric) Repeat time in seconds}

\item{direction}{(character) Direction of acquisition}

\item{indexing}{(character) Whether indexing was bottom up (default) or
down using \code{--down} option}

\item{acq_order}{(character) Order of acquisition, either contiguous 
or interleaved}

\item{verbose}{(logical) print out command before running}

\item{...}{additional arguments passed to \code{\link{readnii}}.}
}
\value{
If \code{retimg} then object of class nifti.  Otherwise,
Result from system command, depends if intern is TRUE or FALSE.
}
\description{
This function calls \code{slicetimer} and performs
slice timing correction for fMRI data
}
\note{
Functions with underscores have different defaults
and will return an output filename, so to be used for piping
}
