% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fslhd.R
\name{fslval}
\alias{fslval}
\title{Get value from FSL header}
\usage{
fslval(file, keyword = "", verbose = TRUE, ...)
}
\arguments{
\item{file}{(character) image filename or character of class nifti}

\item{keyword}{(character) keyword to be taken from fslhd}

\item{verbose}{(logical) print out command before running}

\item{...}{options passed to \code{\link{checkimg}}}
}
\value{
Character of infromation from fslhd field specified in keyword
}
\description{
This function calls \code{fslval} to obtain a nifti header
}
\examples{
if (have.fsl()){
 mnifile = file.path(fsldir(), "data", "standard", 
   "MNI152_T1_2mm.nii.gz")
 fslval(mnifile, keyword = "dim1")
}  
}

