% Generated by roxygen2 (4.0.1): do not edit by hand
\name{fslsmooth}
\alias{fslsmooth}
\title{Gaussian smooth image using FSL}
\usage{
fslsmooth(file, sigma = 10, mask = NULL, outfile = NULL, retimg = FALSE,
  reorient = FALSE, intern = TRUE, ...)
}
\arguments{
\item{file}{(character) image to be smoothed}

\item{sigma}{(numeric) sigma (in mm) of Gaussian kernel for smoothing}

\item{mask}{(character) optional mask given for image}

\item{outfile}{(character) resultant smoothed image name (optional)
if not give, will be the stub of the filename then _sigma}

\item{retimg}{(logical) return image of class nifti}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link{readNIfTI}}.}

\item{intern}{(logical) to be passed to \code{\link{system}}}

\item{...}{additional arguments passed to \code{\link{readNIfTI}}.}
}
\value{
Result from system command, depends if intern is TRUE or FALSE.
}
\description{
This function calls \code{fslmaths -s} to smooth an image and either
saves the image or returns an object of class nifti
}
\examples{
if (have.fsl()){
system.time({
x = array(rnorm(1e6), dim = c(100, 100, 100))
img = nifti(x, dim= c(100, 100, 100),
datatype = convert.datatype()$FLOAT32, cal.min = min(x),
cal.max = max(x), pixdim = rep(1, 4))
s.img = fslsmooth(img, retimg=TRUE)
})
}
}

