% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coloredmesh.R
\name{coloredmesh.from.mask}
\alias{coloredmesh.from.mask}
\title{Create a coloredmesh from a mask.}
\usage{
coloredmesh.from.mask(
  subjects_dir,
  subject_id,
  mask,
  hemi,
  surface = "white",
  colormap = NULL,
  surface_data = NULL,
  makecmap_options = list(colFn = squash::rainbow2)
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{string. The subject identifier.}

\item{mask}{logical vector, contains one logical value per vertex.}

\item{hemi}{string, one of 'lh' or 'rh'. The hemisphere name. Used to construct the names of the label data files to be loaded.}

\item{surface}{character string or `fs.surface` instance. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{colormap}{a colormap function. See the squash package for some colormaps. Defaults to \code{\link{jet}}.}

\item{surface_data}{optional surface mesh object, as returned by \code{\link[fsbrain]{subject.surface}}. If given, used instead of loading the surface data from disk (which users of this function may already have done). Defaults to NULL.}

\item{makecmap_options}{named list of parameters to pass to \code{\link{makecmap}}. Must not include the unnamed first parameter, which is derived from 'measure'.}
}
\value{
coloredmesh. A named list with entries: "mesh" the \code{\link{tmesh3d}} mesh object. "col": the mesh colors. "render", logical, whether to render the mesh. "hemi": the hemisphere, one of 'lh' or 'rh'.
}
\description{
Create a coloredmesh from a mask.
}
\seealso{
Other mask functions: 
\code{\link{mask.from.labeldata.for.hemi}()},
\code{\link{vis.mask.on.subject}()}

Other coloredmesh functions: 
\code{\link{coloredmesh.from.annot}()},
\code{\link{coloredmesh.from.label}()},
\code{\link{coloredmesh.from.morph.native}()},
\code{\link{coloredmesh.from.morph.standard}()},
\code{\link{coloredmesh.from.morphdata}()},
\code{\link{coloredmeshes.from.color}()}
}
\concept{coloredmesh functions}
\concept{mask functions}
