% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{mesh.vertex.neighbors}
\alias{mesh.vertex.neighbors}
\title{Compute neighbors of a vertex}
\usage{
mesh.vertex.neighbors(surface, source_vertices)
}
\arguments{
\item{surface}{a surface as returned by functions like \code{\link[fsbrain]{subject.surface}}.}

\item{source_vertices}{Vector of source vertex indices.}
}
\value{
the neighbors as a list with two entries: "faces": an vector of the face indices of all faces the source_vertices are a part of. "vertices": an n x 3 matrix of the vertex indices of all vertices of the faces in the 'faces' property. These vertex indices contain the indices of the source_vertices themselves, and they can of course contain duplicates (but not within a single row of the matrix) in the case that two of the source_vertices share a neighbor.
}
\description{
Given a set of query vertex indices and a mesh *m*, compute all vertices which are adjacent to the query vertices in the mesh. A vertex *u* is *adjacent* to another vertex *v* iff there exists an edge *e = (u, v)* in *m*. While you could call this function repeatedly with the old output as its new input to extend the neighborhood, you should maybe use a proper graph library for this.
}
\seealso{
Other surface mesh functions: \code{\link{subject.surface}}
}
\concept{surface mesh functions}
