% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsdir_abstraction_subject.R
\name{subject.morph.standard}
\alias{subject.morph.standard}
\title{Retrieve standard space morphometry data for a single subject.}
\usage{
subject.morph.standard(subjects_dir, subject_id, measure, hemi,
  fwhm = "10", template_subject = "fsaverage", format = "mgh")
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id, }{string. The subject identifier}

\item{measure, }{string. Name of the vertex-wise measure of morphometry data file. E.g., "area" or "thickness". Used to construct the name of the morphometry file to be loaded.}

\item{hemi, }{string, one of 'lh', 'rh', or 'both'. The hemisphere name. Used to construct the names of the annotation and morphometry data files to be loaded.}

\item{fwhm, }{string. Smoothing as string, e.g. '10' or '25'.}

\item{template_subject, }{string. Template subject name, defaults to 'fsaverage'.}

\item{format, }{string. One of 'mgh', 'mgz', 'curv'. Defaults to 'mgh'.}
}
\value{
vector with standard space morph data
}
\description{
Load standard space morphometry data (like 'surf/lh.area.fwhm10.fsaverage.mgh') for a subject from disk. Uses knowledge about the FreeSurfer directory structure to load the correct file.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   thickness_lh = subject.morph.standard(subjects_dir, "subject1", "thickness", "lh", fwhm='10');
}

}
\seealso{
Other morphometry data functions: \code{\link{group.morph.native}},
  \code{\link{group.morph.standard}},
  \code{\link{subject.morph.native}}
}
\concept{morphometry data functions}
