% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a.R
\name{extract_forest}
\alias{extract_forest}
\title{Extract the forest}
\usage{
extract_forest(x)
}
\arguments{
\item{x}{A model to convert; has to hold the forest (\code{forest=TRUE} flag passed to \code{fru}).}
}
\value{
A data frame with the forest structure.
Each row represents a step in a left-first, depth-first walk over the forest.
The \code{Feature} column holds, for branches, the feature used for a split, or NA, for leaves.
Similarly, \code{Threshold} and \code{Subset} columns hold the splitting criterion for branches; they exists only when holding any data.
For a numerical or integer split, observations with values strictly larger than threshold are sent left.
For a subset split, observations with values in the threshold subsets are sent left.
Logical splits have a fixed criterion, \code{TRUE}s are sent left.
This way, they have no corresponding criterion column.
Finally, leaf visits have their vote stored in the \code{Vote colum}.
}
\description{
Extracts the whole decision forest as a left-first, depth-first walk over all vertices.
}
\note{
This function will solidify the model object.
}
