% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_submodel_network.R
\name{plot_submodel_network}
\alias{plot_submodel_network}
\title{Visualize submodel networks}
\usage{
plot_submodel_network(
  x,
  show_clusters = TRUE,
  directed = FALSE,
  igraphlayout = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{"frscore"} or \code{"frscored_cna"}.}

\item{show_clusters}{Logical; should clusters be visualized?}

\item{directed}{Logical; should submodel relations be represented as
directional?}

\item{igraphlayout}{Logical; should igraph layout be used?}

\item{...}{additional arguments to \code{visNetwork()}.}
}
\value{
A \code{visNetwork} object.
}
\description{
Visualize the output of \code{frscore()} and \code{frscored_cna()} by
generating a network representation of submodel relations among the scored
model types.
}
\details{
\code{plot_submodel_network()} takes as input a results object returned
by \code{\link[=frscore]{frscore()}} or
\code{\link[=frscored_cna]{frscored_cna()}}, and creates a network
visualization of the submodel relations among the scored models using
\code{\link[visNetwork:visNetwork]{visNetwork()}}. The nodes of the network
represent unique model types, and an edge between two nodes represents a
submodel relation between those model types. By default, the edges of the
network are undirected. Setting \code{directed = TRUE} creates a directed
network with edges pointing from submodels to supermodels. As it is only
the presence of and not the direction of submodel relations that matters
for the fr-score of a model type, the directed network provides no
additional information about fr-scores over and above the undirected
network. By default, the network color-codes clusters of model types based
on edge-betweenness, calculated with
\code{\link[igraph:cluster_edge_betweenness]{cluster_edge_betweenness()}} from the
package \code{igraph}. The clusters are always based on undirected
edge-betweenness to reflect the fact that only the presence of
submodel-relations, not their direction, is relevant for fr-scores. The
clusters can be turned off by setting \code{show_clusters = FALSE}. The
network plot uses \code{igraph} layout by default, this can be changed to
\code{visNetwork} default by setting \code{igraphlayout = FALSE}. The
visualization can be customized by passing other \code{visNetwork()} arguments
in \code{...}, and by using other functions from the \code{visNetwork} package (see
examples). The purpose of \code{plot_submodel_network()} is to provide a
convenient way of visualizing submodel relations calculated by the
\code{frscore} functions, at the expense of limited flexibility. For further
analysis of the submodel network and more visualization options,
\link[=submodel_adjacencies_to_igraph]{´submodel_adjacencies_to_igraph()´}
produces an \code{igraph} graph of submodel relations from an adjacency matrix
included in \code{\link[=frscore]{frscore()}} and
\code{\link[=frscored_cna]{frscored_cna()}} output.
}
\examples{
r <- frscored_cna(d.error)
v <- plot_submodel_network(r)
v
# customize or override general options
v <- visNetwork::visOptions(v, highlightNearest = TRUE)
v
}
