% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_centsums.R
\docType{methods}
\name{accessor}
\alias{accessor}
\alias{sums}
\alias{sums,centsums-method}
\alias{moments}
\alias{moments,centsums-method}
\title{Accessor methods.}
\usage{
sums(x)

\S4method{sums}{centsums}(x)

moments(x, type = c("central", "raw", "standardized"))

\S4method{moments}{centsums}(x, type = c("central", "raw", "standardized"))
}
\arguments{
\item{x}{a \code{centsums} object.}

\item{type}{the type of moment to compute.}
}
\description{
Access slot data from a \code{centsums} object.
}
\note{
The moment computations provided by fromo are 
numerically robust, but will often \emph{not} provide the
same results as the 'standard' implementations,
due to differences in roundoff. We make every attempt to balance
speed and robustness. User assumes all risk from using
the fromo package.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
