% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fromo.r
\docType{package}
\name{fromo-package}
\alias{fromo-package}
\title{Fast Robust Moments.}
\description{
Fast, numerically robust moments computations, along with computation of
cumulants, running means, etc.
}
\note{
The moment computations provided by fromo are 
numerically robust, but will often \emph{not} provide the
same results as the 'standard' implementations,
due to differences in roundoff. We make every attempt to balance
speed and robustness. User assumes all risk from using
the fromo package.

This package was developed as an exercise in learning Rcpp.
}
\section{Robust Moments}{


Welford described a method for 'robust' one-pass computation of the
standard deviation. By 'robust', we mean robust to round-off caused
by a large shift in the mean. This method was generalized by Terriberry,
and Bennett \emph{et. al.} to the case of higher-order moments. 
This package provides those algorithms for computing moments.

Generally we should find that the stock implementations of \code{sd},
\code{skewness} and so on are \emph{already} robust and likely using
these algorithms under the hood. This package was written for a few
reasons:
\enumerate{
\item As an exercise to learn Rcpp.
\item Often I found I needed the first \eqn{k} moments. For example,
when computing the Z-score, the standard deviation and mean must be
computed separately, which is inefficient. Similarly Merten's correction
for the standard error of the Sharpe ratio uses the first four moments.
These are all computed as a side effect of computation of the kurtosis,
but discarded by the standard methods.
}
}

\section{Legal Mumbo Jumbo}{


fromo is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.
}

\references{
Terriberry, T. "Computing Higher-Order Moments Online."
\url{http://people.xiph.org/~tterribe/notes/homs.html}

J. Bennett, et. al., "Numerically Stable, Single-Pass, 
Parallel Statistics Algorithms," Proceedings of IEEE
International Conference on Cluster Computing, 2009.
\url{https://www.semanticscholar.org/paper/Numerically-stable-single-pass-parallel-statistics-Bennett-Grout/a83ed72a5ba86622d5eb6395299b46d51c901265}

Cook, J. D. "Accurately computing running variance."
\url{http://www.johndcook.com/standard_deviation.html}

Cook, J. D. "Comparing three methods of computing 
standard deviation."
\url{http://www.johndcook.com/blog/2008/09/26/comparing-three-methods-of-computing-standard-deviation}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{package}
