% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_modified_last.R
\name{file_modified_last}
\alias{file_modified_last}
\title{Get the File Modified Last}
\usage{
file_modified_last(...)
}
\arguments{
\item{...}{Arguments passed to \code{\link{list.files}}.}
}
\value{
The path to the file last modified.
}
\description{
I often look for the  file modified last under some directory.
}
\examples{
for (suffix in c(".txt", ".ascii"))
    for (f in file.path(tempdir(), letters))
        touch(paste0(f, suffix))
list.files(tempdir())
file_modified_last(path = tempdir(), pattern = "\\\\.txt$")
dir.create(file.path(tempdir(), "new"))
touch(file.path(tempdir(), "new", "file.txt"))
file_modified_last(path = tempdir(), pattern = "\\\\.txt$")
file_modified_last(path = tempdir(), pattern = "\\\\.txt$", recursive = TRUE)
}
\seealso{
Other searching functions: 
\code{\link{compare_vectors}()},
\code{\link{find_files}()},
\code{\link{fromto}()},
\code{\link{missing_docs}},
\code{\link{search_files}()},
\code{\link{search_rows}()},
\code{\link{summary.filesearch}()}

Other file utilities: 
\code{\link{clipboard_path}()},
\code{\link{delete_trailing_whitespace}()},
\code{\link{develop_test}()},
\code{\link{file_copy}()},
\code{\link{file_save}()},
\code{\link{find_files}()},
\code{\link{get_mtime}()},
\code{\link{get_unique_string}()},
\code{\link{is_files_current}()},
\code{\link{is_path}()},
\code{\link{paths}},
\code{\link{search_files}()},
\code{\link{split_code_file}()},
\code{\link{touch}()}
}
\concept{file utilities}
\concept{searching functions}
