% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rma.R
\name{rma}
\alias{rma}
\title{Moving average process}
\usage{
rma(n, d = 2, Psi = NULL, noise = c("mnormal", "mt"), sigma = NULL, df = 4)
}
\arguments{
\item{n}{number of observations to generate.}

\item{d}{dimension of the time series.}

\item{Psi}{a \code{\link{timedom}} object with operators \code{Psi$operators}, where \code{Psi$operators[,,k]}
is the operator on thelag \code{lags[k]}. If no value is set then we generate a vector moving average process
of order \eqn{1}. Then, \code{Psi$lags = c(1)} and \code{Psi$operators[,,1]} is proportional to \eqn{\exp(-(i+j)\colon 1\leq i, j\leq d)} and such
that the spectral radius of \code{Psi[,,1]} is \eqn{1/2}.}

\item{noise}{\code{mnormal} for multivariate normal noise or \code{mt} for multivariate \eqn{t} noise. If not specified \code{mnormal} is chosen.}

\item{sigma}{covariance  or scale matrix of the innovations. If NULL then the identity matrix is used.}

\item{df}{degrees of freedom if \code{noise = "mt"}.}
}
\value{
A matrix with \code{d} columns and \code{n} rows. Each row corresponds to one time point.
}
\description{
Generates a zero mean vector moving average process.
}
\details{
This simulates a vector moving average process
\deqn{
  X_t=\varepsilon_t+\sum_{k \in lags} \Psi_k \varepsilon_{t-k},\quad 1\leq t\leq n.
}
The innovation process \eqn{\varepsilon_t} is either multivariate normal or multivarite \eqn{t} with
a predefined covariance/scale matrix sigma and zero mean. The noise is generated with the
package \code{mvtnorm}. For Gaussian noise we use \code{\link[mvtnorm]{rmvnorm}}. For Student-t noise we use
\code{\link[mvtnorm]{rmvt}}. The parameters \code{sigma} and \code{df} are imported as arguments, otherwise we use default settings.
}
\seealso{
\code{\link{rar}}
}
\keyword{simulations}
