% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/spectral.density.R
\name{spectral.density}
\alias{spectral.density}
\title{Compute the cross spectral density of processes X and Y}
\usage{
spectral.density(X, Y = NULL, V = NULL, freq = NULL, q = NULL,
  weights = NULL)
}
\arguments{
\item{X}{first process}

\item{Y}{second process, if \code{NULL} then spectral density of X is computed}

\item{V}{correlation structure between coefficients of vectors (default diagonal)}

\item{freq}{evaluation grid - vector of values between \code{[-pi,pi]}}

\item{q}{size of the window (covariances from -q to q will be computed)}

\item{weights}{kernel used to decay significance of covariances with higher lags ('Bartlett', 'trunc', 'Tukey', 'Parzen', 'Bohman', 'Daniell', 'ParzenCogburnDavis').}
}
\value{
Frequency Domain Operator object
}
\description{
Computes the spectral density of processes \eqn{X_t} and \eqn{Y_t} using
a Bartlett style estimator, i.e.
\deqn{ \hat F_\theta^{XY} = \sum_{k=-q}^q W(|k|/q) \hat C_{XY}^k e^{-i\theta k},}
where \eqn{\theta \in [-\pi,\pi]} and \eqn{\hat C_{XY}^k} is the estimated covariance with lag \eqn{k}.
Quality of the estimation depends on choise of the window size \eqn{q}
and \eqn{W} (\code{weights}).
For details on spectral density estimation please refer to "Time Series: Theory and Methods"
by Peter J. Brockwell and Richard A. Davis.
Note that estimator is calculated on the finite grid \code{thetas} so #' in some cases
numerical quality can be improved by choosing a more dense set.
}
\examples{
X = rar(100)
Y = rar(100)
spectral.density(X,Y)
}
\references{
Peter J. Brockwell and Richard A. Davis
Time Series: Theory and Methods
Springer Series in Statistics, 2009
}
\keyword{spec}

