% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_annot.R
\name{read.fs.gca}
\alias{read.fs.gca}
\title{Read FreeSurfer GCA file.}
\usage{
read.fs.gca(filepath)
}
\arguments{
\item{filepath}{character string, path to a file in binary GCA format. Stores array of Gaussian classifiers for probabilistic atlas.}
}
\value{
named list, the file fields. The GCA data is in the data field.
}
\description{
Read FreeSurfer GCA file.
}
\examples{
\dontrun{
gca_file = file.path(Sys.getenv('FREESURFER_HOME'), 'average', 'face.gca');
gca = read.fs.gca(gca_file);
}

}
\author{
This function is based on Matlab code by Bruce Fischl, published under the FreeSurfer Open Source License available at \url{https://surfer.nmr.mgh.harvard.edu/fswiki/FreeSurferSoftwareLicense}. The R version was written by Tim Schaefer.
}
