% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_release.R
\name{fredr_release}
\alias{fredr_release}
\title{Get a release of economic data}
\usage{
fredr_release(release_id, ..., realtime_start = NULL, realtime_end = NULL)
}
\arguments{
\item{release_id}{An integer ID of the release.}

\item{...}{These dots only exist for future extensions and should be empty.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object.
}
\description{
Get a release of economic data
}
\section{API Documentation}{


\href{https://fred.stlouisfed.org/docs/api/fred/release.html}{fred/release}
}

\examples{
if (fredr_has_key()) {
# Release as of today
fredr_release(release_id = 20)

# For some releases, adding realtime dates returns the history of changes
# the release went through
fredr_release(9, realtime_start = as.Date("1950-01-01"))
}
}
\seealso{
\code{\link[=fredr_releases]{fredr_releases()}}, \code{\link[=fredr_releases_dates]{fredr_releases_dates()}}, \code{\link[=fredr_release_dates]{fredr_release_dates()}},
\code{\link[=fredr_release_series]{fredr_release_series()}}, \code{\link[=fredr_release_sources]{fredr_release_sources()}}, \code{\link[=fredr_release_tags]{fredr_release_tags()}},
\code{\link[=fredr_release_related_tags]{fredr_release_related_tags()}}, \code{\link[=fredr_release_tables]{fredr_release_tables()}}
}
