\name{FIR.DM}
\alias{FIR.DM}
\title{FIR.DM model building}
\usage{
  FIR.DM(data.train, num.labels, max.iter, step.size,
    type.tnorm = "MIN", type.snorm = "MAX",
    type.implication.func = "ZADEH")
}
\arguments{
  \item{data.train}{a matrix (\eqn{m \times n}) of
  normalized data for training, where \eqn{m} is the number
  of instances and \eqn{n} is the number of variables. The
  last column is the output variable.  Note the data must
  be normalized between 0 and 1.}

  \item{num.labels}{a matrix (\eqn{1 \times n}) whose
  elements represent the number of labels (fuzzy terms),
  where \eqn{n} is the number of variables.}

  \item{max.iter}{the maximal number of iterations.}

  \item{step.size}{the step size of the descent method,
  between 0 and 1.}

  \item{type.tnorm}{the type of t-norm. For more detail,
  please have a look at \code{\link{inference}}.}

  \item{type.snorm}{the type of s-norm. For more detail,
  please have a look at \code{\link{inference}}.}

  \item{type.implication.func}{a value representing type of
  implication function. For more detail, please have a look
  at \code{\link{WM}}}
}
\description{
  This is the internal function that implements the fuzzy
  inference rules by descent method (FIR.DM). It is used to
  solve regression tasks. Users do not need to call it
  directly, but just use \code{\link{frbs.learn}} and
  \code{\link{predict}}.
}
\details{
  This method was proposed by H. Nomura, I. Hayashi, and N.
  Wakami. FIR.DM uses simplified fuzzy reasoning where the
  consequent part is a real number (a particular case
  within the Takagi Sugeno Kang model), while the
  membership function on the antecedent part is expressed
  by an isosceles triangle. So, in the learning phase,
  FIR.DM updates three parameters which are center and
  width of the triangular and a real number on the
  consequent part using a descent method.
}
\references{
  H. Nomura, I. Hayashi and N. Wakami, "A learning method
  of fuzzy inference rules by descent method", IEEE
  International Conference on Fuzzy Systems, pp. 203 - 210
  (1992).
}
\seealso{
  \code{\link{DM.update}}, \code{\link{frbs.learn}}, and
  \code{\link{predict}}.
}

