% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterate_lsystem.R
\name{iterate_lsystem}
\alias{iterate_lsystem}
\title{Rewrite an Axiom Using Production Rules to Generate a String for Turtle Graphics}
\usage{
iterate_lsystem(init = NULL, rules = NULL, n_iter = 5, verbose = 0L)
}
\arguments{
\item{init}{A character string representing the initial axiom (starting string) for the L-system.}

\item{rules}{A data frame with two columns: \code{inp} (input variables) and \code{out} (corresponding replacement strings). The rules define how each symbol in the axiom should be replaced during the iterations.}

\item{n_iter}{An integer specifying the number of iterations or cycles to apply the production rules. Default is 5.}

\item{verbose}{An integer controlling the verbosity of the output during iterations.
- \code{verbose = 1L}: prints basic information about each cycle.
- \code{verbose > 1L}: provides detailed information about each step.
- \code{verbose < 1L}: suppresses output.}
}
\value{
A character string that represents the final string after all iterations, ready for use in turtle graphics.
}
\description{
This function iterates over a set of production rules to transform an initial axiom (a string) into a final string that can be used for turtle graphics. The rules are applied to the axiom over a specified number of iterations, with each iteration updating the string according to the rules provided.
}
\details{
The function applies the provided production rules to the initial axiom for the specified number of iterations. In each cycle, the rules are applied simultaneously to the current string, and the resulting string is updated. The function also supports different verbosity levels for reporting the transformation progress.
}
\examples{
# Example of a simple L-system with a binary tree
init <- "0"
rules <- data.frame(
  inp = c("0", "1"),
  out = c("1[-(0)]+(0)", "1"),
  stringsAsFactors = FALSE
)
result <- iterate_lsystem(init, rules, n_iter = 3, verbose = 1L)
print(result)

}
