% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accepted_entries.R
\name{accepted_entries}
\alias{accepted_entries}
\title{Return A Data Frame of Plant Species That Successfully Match to the Regional
FQA Database of choice}
\usage{
accepted_entries(
  x,
  key = "name",
  db,
  native = c(TRUE, FALSE),
  wetland_warning = TRUE,
  cover_weighted = FALSE,
  cover_class = "percent_cover",
  allow_duplicates = FALSE,
  allow_no_c = FALSE,
  allow_non_veg = FALSE,
  plot_id = NULL
)
}
\arguments{
\item{x}{A data frame containing a list of plant species. This data frame
must have one of the following columns: \code{name} or \code{acronym}. For cover-weighted or
relative functions, this data frame must also have a column called \code{cover} containing
cover values and ideally a column containing plot IDs.}

\item{key}{A character string representing the column that will be used to join
the input data frame \code{x} with the regional FQA database. If a value is not specified, the
default is \code{"name"}. \code{"name"} and \code{"acronym"} are the only acceptable
values for \code{key}.}

\item{db}{A character string representing the regional FQA database to use. See
\code{db_names} for a list of potential values and the \code{fqadata} R package
where the databases are hosted.}

\item{native}{Boolean (TRUE or FALSE). If TRUE, calculate metrics using only
native species.}

\item{wetland_warning}{Boolean (TRUE or FALSE). If TRUE, show user messages regarding
issues with wetness coefficients.}

\item{cover_weighted}{Boolean (TRUE or FALSE). If TRUE, keep \code{cover} column in output.
Note: if \code{cover_weighted = TRUE}, \code{x} must have a column named \code{cover}. This parameter
is used to calculate cover-weighted metrics such as plot mean c, transect mean c, and
cover-weighted FQI.}

\item{cover_class}{a character string representing the cover classification used. Acceptable
cover classes are: \code{"percent_cover"}, \code{"carolina_veg_survey"}, \code{"braun-blanquet"},
\code{"daubenmire"}, and \code{"usfs_ecodata"}. \code{"percent_cover"} is the default.}

\item{allow_duplicates}{Boolean (TRUE or FALSE). If TRUE, allow \code{x} to have
duplicate observations for the same species. This is only recommended for
calculating transect and relative frequency/abundance metrics. For non cover-weighted (inventory)
assessments allow_duplicates is always FALSE. For cover-weighted functions, allow_duplicates
can be set to TRUE for transect level metrics or FALSE for plot level metrics.}

\item{allow_no_c}{Boolean (TRUE or FALSE). If TRUE, allow species that are found in the
regional FQA database but have not been assigned a C Values. If FALSE, omit species that have not
been assigned C Values.}

\item{allow_non_veg}{Boolean (TRUE or FALSE). If TRUE, allow input to contain un-vegetated
ground and un-vegetated water.}

\item{plot_id}{A character string representing the column in \code{x} that contains plot
identification values. \code{plot_id} is a required argument in \code{plot_summary}, where it acts
as a grouping variable. \code{plot_id} is optional but highly recommended for
cover-weighted functions and relative functions. If \code{plot_id} is set in a
cover-weighted function or a relative function, it only prevents duplicates
from occurring in the same plot. It does not act as a grouping variable.}
}
\value{
A data frame containing the \code{key} column--either \code{acronym} or
\code{name}--as well as columns from the relevant FQA database.
These columns include \code{name_origin} \code{accepted_name}, \code{family}, \code{nativity}, \code{c} (which represents the C Value),
\code{w} (which represents wetness score), \code{physiognomy}, \code{duration}, and \code{common_name}
}
\description{
\code{accepted_entries} takes a data frame of user-entered plant species and returns
a data frame of plant species that are successfully matched to the regional FQA
database of choice. Regional databases are stored in the \code{fqadata} R package.
\code{accepted_entries} is a utility function that is used in all other metric-calculating
functions in this package.
}
\examples{
plant_list <- crooked_island

#with native and introduced species
accepted_entries(x = plant_list, key = "acronym", db = "michigan_2014", native = FALSE)

#with only native species
accepted_entries(x = plant_list, key = "acronym", db = "michigan_2014", native = TRUE)

#an example with duplicates allowed
duplicate_df <- data.frame(acronym  = c("ABEESC", "ABIBAL", "ABIBAL"),
cover = c(60, 50, 50))

accepted_entries(x = duplicate_df, key = "acronym",
db = "michigan_2014", native = FALSE, allow_duplicates = TRUE)

#an example of duplicates not allowed
accepted_entries(x = duplicate_df, key = "acronym",
db = "michigan_2014", native = FALSE, allow_duplicates = FALSE)

#an example of duplicates not allowed, adding cover values
accepted_entries(x = duplicate_df, key = "acronym",
db = "michigan_2014", native = FALSE, allow_duplicates = FALSE,
cover_weighted = TRUE)

#an example where some entries are synonyms shared by more than one species
same_syn <- data.frame(name = c("CAREX MURICATA", "POTENTILLA NANA", "ABIES BIFOLIA"),
cover = c(80, 60, 10))

#produces a warning saying CAREX MURICATA is a synonym to multiple species and will be omitted.
#To include this species, use the accepted scientific name.
accepted_entries(x = same_syn, key = "name",
db = "wyoming_2017", native = FALSE)

#an example where species is both a synonym and an accepted name
same_syn2 <- data.frame(name = c("CAREX FOENEA", "ABIES BIFOLIA"),
cover = c(80, 10))

#produces a warning saying CAREX FOENEA is an accepted scientific name and a synonym.
#It will default to accepted scientific name.
accepted_entries(x = same_syn2, key = "name",
db = "wyoming_2017", native = FALSE)

}
