% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold_ranges.R
\name{threshold_ranges}
\alias{threshold_ranges}
\title{threshold_ranges}
\usage{
threshold_ranges(
  x,
  rank = "genus",
  srt = "max_ma",
  end = "min_ma",
  method = "kernel",
  step = 1,
  density = 0.1,
  use_sd = TRUE,
  win = 5,
  thresh = 5,
  ...,
  report = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{x}{An occurrence dataset containing taxon names,
maximum ages and minimum ages}

\item{rank}{The column name in x containing the taxon names}

\item{srt}{A column name in x denoting the occurrence maximum ages}

\item{end}{A column name in x denoting the occurrence minumum ages}

\item{method}{The method for quantifying occurrence density: one
histogram or kernel. Kernel is the recommended default. As called
be @seealso densify}

\item{step}{A positive integer specifying the time window size
for density calculation. As called by @seealso densify}

\item{density}{A positive numeric specifying the step size for
densifying records. This should ideally be smaller than step.
As called by @seealso densify}

\item{use_sd}{A logical determining whether to use peaks detected
as significant using the mean + standard deviation of its neighbourhood.
If FALSE, then the peaks need only be greater than the neighbourhood
mean to be significant. Thus, use_sd is more conservative, but less
prone to noise. As called by @seealso find_peaks}

\item{win}{A positive integer specifying the neighborhood window length
on either side of a peak durign significance testing (i.e. win 5 will
give a total window of 11: -5 indices + peak index + 5 indices). As
called by @seealso find_peaks}

\item{thresh}{The threshold distance between peaks above which
they will be considered distinct - given in Ma}

\item{...}{additional arguments passed to @seealso density}

\item{report}{A logical determining if the analytical outputs of the
function be returned to the user, as well as the revised taxon names, TRUE
by default}

\item{verbose}{A logical determining if function progress
should be reported}
}
\value{
If report = TRUE (the default), a list of five elements. $data
gives the thresholded (and potentially subdivided) taxon names. $matrix
is the taxon-wise matrix of occurrence densities. $peaks is a list
containing three lists of peaks (all peaks, significant by mean + sd,
significant by sd only) for each taxon and a dataframe of peak counts
between the three treatments. $comparison
}
\description{
Function to detect if two peaks in a density spectrum can
be considered separate based on a user supplied threshold.
Creates a sequence of divisions from the troughs immediately
preceding any significant peaks, then bins occurrences for
a given taxon name by those divisions.
}
\examples{
# load dataset
data("brachios")
# subsample brachios to make for a short example runtime
set.seed(1)
brachios <- brachios[sample(1:nrow(brachios), 1000),]
# interpeak thresholding
itp <- threshold_ranges(brachios, win = 8, thresh = 10,
                        rank = "genus", srt = "max_ma", end = "min_ma")
}
