% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readFam.R
\name{readFam}
\alias{readFam}
\title{Read \code{Familias} .fam files}
\usage{
readFam(famfile, useDVI = NA, Xchrom = FALSE, verbose = TRUE)
}
\arguments{
\item{famfile}{Path to a ".fam" file.}

\item{useDVI}{A logical, indicating if the DVI section of the fam file should
be identified and parsed. If \code{NA} (the default), the DVI section is
included if it is present in the input file.}

\item{Xchrom}{A logical. If TRUE, the \code{chrom} attribute of all markers will
be set to "X". (Default = FALSE.)}

\item{verbose}{A logical. If TRUE, various information is written to the
screen during the parsing process.}
}
\value{
If the .fam file only contains a database, the output is a list of
information (name, alleles, frequencies) about each locus. This list can be
used as \code{locusAttributes} in e.g. \code{\link[=setMarkers]{setMarkers()}}.

If the .fam file describes pedigree data, the output is a \code{ped} object or a
list of such.

If \code{useDVI = TRUE}, then the families described under \verb{Reference Families}
are parsed and converted to \code{ped} objects. Each family generally describes
multiple pedigrees, so the output gets another layer in this case.
}
\description{
This function parses the content of a \code{Familias}-formatted ".fam" file, and
converts it into suitable \code{ped} objects. This function does not depend on the
\code{Familias} R package.
}
