% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileSim.R
\name{profileSim}
\alias{profileSim}
\title{Simulation of complete DNA profiles}
\usage{
profileSim(
  x,
  N = 1,
  ids = NULL,
  markers = NULL,
  seed = NULL,
  numCores = 1,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{N}{The number of complete simulations to be performed.}

\item{ids}{A character (or coercible to character) with ID labels indicating
whose genotypes should be simulated.}

\item{markers}{A list of marker objects, or a vector containing names or
indices referring to markers attached to \code{x}. By default (\code{NULL}), all
attached markers are used. The simulations will be conditional on the locus
attributes (allele frequencies, mutation models a.s.o.) and any existing
genotypes in the indicated markers.}

\item{seed}{An integer seed for the random number generator (optional).}

\item{numCores}{The number of cores used for parallelisation, by default 1.}

\item{verbose}{A logical, by default TRUE.}

\item{...}{Further arguments passed on to \code{\link[=markerSim]{markerSim()}}.}
}
\value{
A list of \code{N} objects similar to \code{x}, but with simulated genotypes.
Any previously attached markers are replaced by the simulated profiles. If
the indicated markers contained genotypes for some pedigree members, these
are still present in the simulated profiles.
}
\description{
Simulation of DNA profiles for specified pedigree members. Some pedigree
members may already be genotyped; in that case the simulation is conditional
on these. The main work of this function is done by \code{\link[=markerSim]{markerSim()}}.
}
\examples{
# Example with two brothers
x = nuclearPed(children = c("B1", "B2"))

# Attach two markers; one brother is already genotyped
m1 = marker(x, B1 = 1:2, alleles = 1:3)
m2 = marker(x, B1 = 1, alleles = 1:4, afreq = (1:4)/10, chrom = "X")
x = setMarkers(x, list(m1, m2))

# Simulate 3 profiles of B2 conditional on the above
profileSim(x, N = 3, ids = "B2")

}
