% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingPersonEP.R
\name{missingPersonEP}
\alias{missingPersonEP}
\title{Exclusion power for missing person cases}
\usage{
missingPersonEP(
  reference,
  missing,
  markers = NULL,
  disableMutations = NA,
  verbose = TRUE
)
}
\arguments{
\item{reference}{A \code{ped} object with attached markers.}

\item{missing}{The ID label of the missing pedigree member.}

\item{markers}{A vector indicating the names or indices of markers attached
to the source pedigree. If NULL (default), then all markers attached to the
source pedigree are used. If \code{alleles} or \code{afreq} is non-NULL, then this
parameter is ignored.}

\item{disableMutations}{This parameter determines how mutation models are
treated. Possible values are as follows:
\itemize{
\item \code{NA} (the default): Mutations are disabled only for those markers whose
known genotypes are consistent with \code{reference}. This is determined by
temporarily removing all mutation models and checking which markers have
nonzero likelihood.
\item \code{TRUE}: Mutations are disabled for all markers. This will result in an
error if any markers are inconsistent with \code{reference}.
\item \code{FALSE}: No action is done to disable mutations.
\item A vector containing the names or indices of those markers for which
mutations should be disabled.
}}

\item{verbose}{A logical.}
}
\value{
The \code{EPresult} object returned by \code{\link[=exclusionPower]{exclusionPower()}}.
}
\description{
This is a wrapper of \code{\link[=exclusionPower]{exclusionPower()}} for the special case of a reference
family with a single missing member. Some reference members should already be
genotyped. The function computes the power to exclude an unrelated
individual, i.e. the probability of observing (in a truly unrelated
individual) a genotype incompatible with the reference.
}
\examples{

# Four siblings; the fourth is missing
x = nuclearPed(4)

# Remaining sibs typed with 4 triallelic markers
x = markerSim(x, N = 4, ids = 3:5, alleles = 1:3, seed = 577, verbose = FALSE)

# Add marker with inconsistency in reference genotypes
# (this should be ignored by `missingPersonEP()`)
badMarker = marker(x, `3` = 1, `4` = 2, `5` = 3)
x = addMarkers(x, badMarker)

# Compute exclusion power statistics
missingPersonEP(x, missing = 6)

# With marker names:
name(x, 1:5) = paste0("M", 1:5)
missingPersonEP(x, missing = 6)

}
