% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinshipLR.R
\name{kinshipLR}
\alias{kinshipLR}
\title{Likelihood ratios for kinship testing}
\usage{
kinshipLR(x, ref, markers)
}
\arguments{
\item{x}{A list of pedigree alternatives. Each alternative should be either a
single \code{ped} object or a list of such.}

\item{ref}{A single integer, indicating the index (in the list \code{x}) of the
reference alternative. This is used in the denominator of each LR.}

\item{markers}{A vector of integers, indexing which markers should be
included. If NULL (the default) all markers are used.}
}
\value{
A \code{LRresult}object, which is essentially a list with entries
\itemize{
\item \code{LRtotal} : Total likelihood ratios
\item \code{LRperMarker} : Likelihood ratios for each marker
\item \code{likelihoodsPerMarker} : Likelihoods for each marker
\item \code{time} user system and elapsed time
}
}
\description{
This function computes likelihood ratios (LRs) for a given a list of
pedigrees with attached markers. The user must indicate which of the
pedigrees is the 'reference', which will be used in the denominator in each
LR.
}
\examples{

# Simulate 5 markers for a pair of full sibs
set.seed(123)
sibs = nuclearPed(children = c("A", "B"))
sibs = simpleSim(sibs, N = 5, alleles = 1:4, ids = c("A", "B"))

# Create two alternative hypotheses and transfer the simulated genotypes to them
halfsibs = relabel(halfSibPed(), old = 4:5, new = c("A", "B"))
halfsibs = transferMarkers(sibs, halfsibs)

unrel = list(singleton("A"), singleton("B"))
unrel = transferMarkers(sibs, unrel)

# Compute LR with 'unrelated' as reference
res = kinshipLR(list(sibs, halfsibs, unrel), ref = 3)
res

# Detailed results
res$LRperMarker
res$likelihoodsPerMarker
}
\seealso{
\code{\link[=LRpower]{LRpower()}}, \code{\link[pedtools:transferMarkers]{pedtools::transferMarkers()}}
}
\author{
Magnus Dehli Vigeland and Thore Egeland
}
