% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DW_Server.R
\name{DW_attach_ds}
\alias{DW_attach_ds}
\title{Attach Data Set to DW State}
\usage{
DW_attach_ds(state, id_UD, session)
}
\arguments{
\item{state}{DW state from \code{DW_fetch_state()}}

\item{id_UD}{ID string for the upload data module used to handle uploads}

\item{session}{Shiny session variable}
}
\value{
state with data set attached
}
\description{
Attaches a dataset to the DW state supplied.
}
\examples{
# Within shiny both session and input variables will exist,
# this creates examples here for testing purposes:
sess_res = DW_test_mksession(session=list())
session = sess_res$session
input   = sess_res$input

# We also need a state variable
state = sess_res$state

# We need to identify the UD module with the data
id_UD = "UD"
state = DW_attach_ds(state, id_UD, session)
}
