% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pagination.R
\name{pagdfrow}
\alias{pagdfrow}
\title{Create a row of a pagination data frame}
\usage{
pagdfrow(
  row,
  nm = obj_name(row),
  lab = obj_label(row),
  rnum,
  pth,
  sibpos = NA_integer_,
  nsibs = NA_integer_,
  extent = nlines(row, colwidths),
  colwidths = NULL,
  repext = 0L,
  repind = integer(),
  indent = 0L,
  rclass = class(row),
  nrowrefs = 0L,
  ncellrefs = 0L,
  nreflines = 0L,
  force_page = FALSE,
  page_title = NA_character_,
  trailing_sep = NA_character_
)
}
\arguments{
\item{row}{(\code{ANY})\cr object representing the row, which is used for default values of \code{nm}, \code{lab},
\code{extent}, and \code{rclass} if provided. Must have methods for \code{obj_name}, \code{obj_label}, and \code{nlines}, to retrieve
default values of \code{nm}, \code{lab}, and \code{extent}, respectively.}

\item{nm}{(\code{string})\cr name.}

\item{lab}{(\code{string})\cr label.}

\item{rnum}{(\code{numeric(1)})\cr absolute row number.}

\item{pth}{(\code{character} or \code{NULL})\cr path within larger table.}

\item{sibpos}{(\code{integer(1)})\cr position among sibling rows.}

\item{nsibs}{(\code{integer(1)})\cr number of siblings (including self).}

\item{extent}{(\code{numeric(1)})\cr number of lines required to print the row.}

\item{colwidths}{(\code{numeric})\cr column widths.}

\item{repext}{(\code{integer(1)})\cr number of lines required to reprint all context for this row if it appears directly
after pagination.}

\item{repind}{(\code{integer})\cr vector of row numbers to be reprinted if this row appears directly after pagination.}

\item{indent}{(\code{integer})\cr indent.}

\item{rclass}{(\code{string})\cr class of row object.}

\item{nrowrefs}{(\code{integer(1)})\cr number of row referential footnotes for this row.}

\item{ncellrefs}{(\code{integer(1)})\cr number of cell referential footnotes for the cells in this row.}

\item{nreflines}{(\code{integer(1)})\cr total number of lines required by all referential footnotes.}

\item{force_page}{(\code{flag})\cr currently ignored.}

\item{page_title}{(\code{flag})\cr currently ignored.}

\item{trailing_sep}{(\code{string})\cr the string to use as a separator below this row during printing.
If \code{NA_character_}, no separator is used.}
}
\value{
A single row \code{data.frame} with the appropriate columns for a pagination info data frame.
}
\description{
Create a row of a pagination data frame
}
