% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{matrix_form}
\alias{matrix_form}
\alias{matrix_form,MatrixPrintForm-method}
\title{Transform \code{rtable} to a list of matrices which can be used for outputting}
\usage{
matrix_form(
  obj,
  indent_rownames = FALSE,
  expand_newlines = TRUE,
  indent_size = 2
)

\S4method{matrix_form}{MatrixPrintForm}(
  obj,
  indent_rownames = FALSE,
  expand_newlines = TRUE,
  indent_size = 2
)
}
\arguments{
\item{obj}{ANY. Object to be transformed into a ready-to-render form (a \code{MatrixPrintForm} object)}

\item{indent_rownames}{logical(1), if TRUE the column with the row names in the \code{strings} matrix of has indented row
names (strings pre-fixed)}

\item{expand_newlines}{logical(1). Should the matrix form generated
expand  rows  whose  values   contain  newlines  into  multiple
'physical'  rows  (as  they  will  appear  when  rendered  into
ASCII). Defaults to \code{TRUE}}

\item{indent_size}{numeric(1). Number of spaces to be used per level of indent (if supported by
the relevant method). Defaults to 2.}
}
\value{
A \code{MatrixPrintForm} classed list with the following elements:
\describe{
\item{strings}{The content, as it should be printed, of the top-left material, column headers, row labels, and
cell values of \code{tt}}
\item{spans}{The column-span information for each print-string in the strings matrix}
\item{aligns}{The text alignment for each print-string in the strings matrix}
\item{display}{Whether each print-string in the strings matrix should be printed or not}.
\item{row_info}{the data.frame generated by \code{summarize_rows(tt)}}
}

With an additional \code{nrow_header} attribute indicating the number of pseudo "rows"  the
column structure defines.
}
\description{
Although \code{rtables} are represented as a tree data structure when outputting the table to ASCII or HTML it is useful to
map the \code{rtable} to an in between state with the formatted cells in a matrix form.
}
\details{
The strings in the return object are defined as follows: row labels are those determined by \code{summarize_rows} and
cell values are determined using \code{get_formatted_cells}.
(Column labels are calculated using a non-exported internal function.
}
