#' @title 
#' Inventory data of an eucalyptus forest in Brazil, with age and site variables
#' @description 
#' In this data, each observation is a plot. The site was estimated using the Chapman & Richards model.
#' @usage 
#' data(exfm12)
#' 
#' @format
#' A data frame with 139 observations and 8 variables:
#' \describe{
#'   \item{strata}{stratum number}
#'   \item{plot}{plot number}
#'   \item{age}{average age of plots, in months}
#'   \item{DH}{dominant height, in meters}
#'   \item{N}{number of individuals}
#'   \item{V}{volume of trees, in cubic meters}
#'   \item{B}{basal area, in square meters}
#'   \item{S}{site variable, in meters}   
#' }
#' @name exfm12
#' @docType data
#' @author Sollano Rabelo Braga \email{sollanorb@@gmail.com}
#' @keywords data
NULL