% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLAD.R
\name{fd_forest_glad}
\alias{fd_forest_glad}
\title{Global Land Analysis & Discovery datasets}
\usage{
fd_forest_glad(
  x = NULL,
  lon = NULL,
  lat = NULL,
  model = "extent",
  year = 2020,
  crop = FALSE,
  mask = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{x}{a \code{sf} or \code{SpatVector} object. It will retrieve the necessary
tiles to cover the area (if \code{lat} and \code{lon} are specified, this
argument is ignored)}

\item{lon}{a number specifying the longitude of the area where we want the tile}

\item{lat}{a number specifying the latitude of the area where we want the tile}

\item{model}{a character vector of length 1 indicating the model to retrieve (see details)}

\item{year}{year of the data (see details)}

\item{crop}{when \code{x} is specified, whether to crop the tile(s) to the object}

\item{mask}{when \code{x} is specified, whether to mask the tile(s) to the object}

\item{quiet}{if \code{TRUE}, suppress any message or progress bar}
}
\value{
\code{SpatRaster} object
}
\description{
Download data from GLAD database including forest extent, forest height, and
land cover at ~30m spatial resolution
}
\details{
The Global Land Analysis & Discovery (GLAD) includes several datasets which
can be accessed through the \code{model} argument:
\itemize{
\item \strong{landcover}: global land cover and land use dataset. Dataset divided into
10ºx10º tiles containing measures of bare ground and tree height inside and
outside of wetlands, seasonal water percent, binary labels of built-up,
permanent ice/snow, and cropland. Available for the years 2000, 2005, 2010,
2015, and 2020.
\item \strong{landcover-change}: changes of landcover from 2000 to 2020. Argument
\code{year} is ignored.
\item \strong{extent}: dataset showing presence of forest, defined as wildland, managed,
and planted tree cover including agroforestry and orchards. Includes areas where
the vegetation is taller than 5 meters. Available for the years 2000 and 2020.
\item \strong{height}: dataset measuring the height of woody vegetation taller
than 3 meters. Available for the years 2000 and 2020.
}

The spatial resolution of the product is 0.00025º (approximately 30 meters
at the Equator), and it's distributed in tiles of 10ºx10º.

Note that each tile is stored as a raster file of 1.5 GB, so for
big extensions the function might take some time to retrieve the data.
}
\examples{
\donttest{
 # Get tile for Galicia (Spain)
 galicia_forest_extent <- fd_forest_glad(lon = -7.8, lat = 42.7, year = 2020)
}
}
\references{
Potapov P., Hansen M.C., Pickens A., Hernandez-Serna A., Tyukavina A.,
Turubanova S., Zalles V., Li X., Khan A., Stolle F., Harris N., Song X.-P.,
Baggett A., Kommareddy I., Kommareddy A. (2022) The global 2000-2020 land cover
and land use change dataset derived from the Landsat archive: first results.
Frontiers in Remote Sensing \doi{10.3389/frsen.2022.856903}

P. Potapov, X. Li, A. Hernandez-Serna, A. Tyukavina, M.C. Hansen, A. Kommareddy,
A. Pickens, S. Turubanova, H. Tang, C.E. Silva, J. Armston, R. Dubayah, J. B.
Blair, M. Hofton (2020) Mapping and monitoring global forest canopy height
through integration of GEDI and Landsat data. Remote Sensing of Environment,
112165.\doi{10.1016/j.rse.2020.112165}
}
