% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_deeplearning_utils.R
\name{pred.tskeras}
\alias{pred.tskeras}
\title{Time series forecasts for a keras model.}
\usage{
pred.tskeras(object, h = 1)
}
\arguments{
\item{object}{An object from keras.}

\item{h}{Number of periods for forecasting.}
}
\value{
Point forecasts as a time series.
}
\description{
Time series forecasts for a keras model.
}
\examples{
\donttest{
  library(keras)
  modelo.deep <- keras_model_sequential() \%>\% 
  layer_lstm(
    units = 10, activation = 'tanh', batch_input_shape = c(1, 12, 1),
    return_sequences = TRUE, stateful = TRUE) \%>\%
  layer_dense(units = 1) \%>\%
  compile(loss = 'mse', optimizer = 'adam', metrics = 'mse')
  modelo.deep <- tskeras(AirPassengers, modelo.deep, lag = 12, epochs = 1)
  pred.tskeras(modelo.deep, h = 12)
}

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
