% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\docType{data}
\name{inrap}
\alias{inrap}
\title{Location of Inrap Archaeological Sites}
\format{
A \code{data.frame} with 625 observations (archaeological sites) and 11 variables:
\describe{
\item{X}{\code{\link{numeric}}: longitude (RGF93 v1 / Lambert-93).}
\item{Y}{\code{\link{numeric}}: latitude (RGF93 v1 / Lambert-93).}
\item{region}{\code{\link{character}}: French region.}
\item{departement}{\code{\link{character}}: French departement.}
\item{commune}{\code{\link{character}}: French city.}
\item{site}{\code{\link{character}}: name of the site.}
\item{start}{\code{\link{Date}}: excavation start date.}
\item{end}{\code{\link{Date}}: excavation end date.}
\item{period}{\code{\link{list}}: chronology periods.}
\item{theme}{\code{\link{list}}: themes.}
\item{type}{\code{\link{character}}.}
}
}
\source{
\url{https://www.data.gouv.fr/fr/datasets/r/b098d16a-ae19-48e4-8c58-e659e0603acd}
(last update: 2024-06-03)
}
\usage{
inrap
}
\description{
A dataset of geographical locations of archaeological sites in France.
}
\details{
This dataset presents the geographical locations of a selection of
preventive archaeological excavations carried out in France by the
Institut national de recherches archéologiques préventives (Inrap).
}
\examples{
# library(sf)
# coord <- st_as_sf(inrap, coords = c("X", "Y"), crs = st_crs(2154))
# plot(coord["region"])
}
\seealso{
Other geographical data: 
\code{\link{cities}}
}
\concept{geographical data}
\keyword{datasets}
