% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fG_osar.R
\name{plot.fG_osar}
\alias{plot.fG_osar}
\title{plot}
\usage{
\method{plot}{fG_osar}(
  x,
  type = c("ts", "qqnorm", "acf"),
  pages = 1,
  ncol = 1,
  ask = TRUE,
  pal = "Zissou1",
  ...
)
}
\arguments{
\item{x}{a \code{foieGras osar} object with class \code{fG_osar}}

\item{type}{type of residual plot to generate; time-series (ts), qqnorm (qq; default) or acf (note: hist is deprecated)}

\item{pages}{plots of all individuals on a single page (pages = 1; default) or each individual on a separate page (pages = 0)}

\item{ncol}{number of columns to use for faceting. Default is ncol = 2 but this may be increased for multi-individual fit objects}

\item{ask}{logical; if TRUE (default) user is asked for input before each plot is rendered. set to FALSE to return ggplot objects}

\item{pal}{\code{hcl.colors} colour palette to use (default = "Zissou1"; type \code{hcl.pals()} for options)}

\item{...}{additional arguments to be ignored}
}
\description{
plot One-Step-Ahead (prediction) residuals from a \code{foieGras osar} object
}
\examples{
## generate a fG_ssm fit object (call is for speed only)
xs <- fit_ssm(sese2, spdf=FALSE, model = "rw", time.step=72, 
control = ssm_control(se = FALSE, verbose = 0))

dres <- osar(xs[2, ]) # only use one seal to save time
plot(dres, type = "qq")

}
