% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim}
\alias{sim}
\title{simulate animal tracks}
\usage{
sim(
  N = 100,
  start = list(c(0, 0), as.POSIXct(format(Sys.time(), tz = "UTC", usetz = TRUE))),
  model = c("rw", "crw", "mpm"),
  vmax = 4,
  sigma = c(4, 4),
  rho_p = 0,
  D = 0.05,
  sigma_g = 1.25,
  error = c("ls", "kf"),
  tau = c(1.5, 0.75),
  rho_o = 0,
  tdist = c("reg", "gamma"),
  ts = 3,
  tpar = c(0.23, 1),
  alpha = c(0.9, 0.8)
)
}
\arguments{
\item{N}{number of time steps to simulate}

\item{start}{coordinates and datetime of start location for simulated track}

\item{model}{simulate from the \code{rw}, \code{crw} or \code{mpm} process models}

\item{vmax}{maximum travel rate (m/s) of simulated animal}

\item{sigma}{a vector of process error sd's for the \code{rw} model
(ignored if \code{model != "rw"})}

\item{rho_p}{correlation parameter for \code{rw} model process covariance matrix
(ignored if \code{model != "rw"})}

\item{D}{diffusion coefficient for \code{crw} model process covariance matrix
(ignored if \code{model != "crw"})}

\item{sigma_g}{random walk sd for time-varying move persistence parameter
(ignored if \code{model != "mpm"})}

\item{error}{indicates whether measurement error should mimic Argos
Least-Squares ("ls") or Argos Kalman Filter ("kf")}

\item{tau}{vector of LS measurement error sd's (ignored if \code{error = "kf"})}

\item{rho_o}{correlation parameter for LS covariance matrix
(ignored if \code{error = "kf"})}

\item{tdist}{distribution for simulating location times ("reg" generates locations
at regular ts intervals, in h; "gamma" uses a gamma distribution to generate random
time intervals)}

\item{ts}{time interval in h (ignored if \code{tdist = "gamma"})}

\item{tpar}{shape and scale parameters for the gamma distributed times
(ignored if \code{tdist = "reg"})}

\item{alpha}{transition probabilities switching model versions of
\code{rw} or \code{crw} models. Probabilities are the transition matrix diagonals
(ignored if sigma has length 2 or D has length 1)}
}
\value{
a tibble is returned with columns that can include some or all of the following,
depending on the arguments used
\item{date}{time as POSIXct tz = UTC (default)}
\item{lc}{Argos location class}
\item{lon}{longitude with error}
\item{lat}{latitude with error}
\item{x}{x in km from arbitrary origin without error}
\item{y}{y in km from arbitrary origin without error}
\item{x.err}{a random deviate drawn from Argos LS or KF error distribution}
\item{y.err}{a random deviate drawn from Argos LS or KF error distribution}
\item{smaj}{Argos error ellipse semi-major axis in m (if error = "kf")}
\item{smin}{Argos error ellipse semi-minor axis in m (if error = "kf")}
\item{eor}{Argos error ellipse orientation in degrees (if error = "kf")}
\item{u}{velocity in x direction (if model = "crw")}
\item{v}{velocity in y direction (if model = "crw")}
\item{b}{behavioural state (if model = "rw" or "crw" and multiple process variances given, see examples)}
\item{g}{movement persistence - the autocorrelation between successive movements on the interval 0,1 (if model = "mpm")}
}
\description{
simulate from the \code{rw}, \code{crw} of \code{mpm} process models
to generate a set of x,y (or lon,lat) coordinates with or without error from
supplied input parameters.
}
\examples{
tr <- sim(N = 200, model = "crw", D = 0.1, error = "kf", tdist = "reg", ts=12)
plot(tr, error = TRUE)

tr <- sim(N = 200, model = "rw", sigma = c(4,4,0.5,0.5), error = "ls", tdist = "reg")
plot(tr)

tr <- sim(N = 200, model = "crw", D = c(0.1, 0.05), error = "kf", tdist="reg")
plot(tr)

tr <- sim(N = 200, model = "mpm", sigma_g = 1.2, error = "ls", tau = c(2, 1.5), 
tdist = "gamma", tpar = c(1, 4))
plot(tr, error = TRUE, pal = "Cividis")

}
