% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idio.R
\name{idio.predict}
\alias{idio.predict}
\title{Forecasting idiosyncratic VAR process}
\usage{
idio.predict(object, x, cpre, n.ahead = 1)
}
\arguments{
\item{object}{\code{fnets} object}

\item{x}{input time series matrix, with each row representing a variable}

\item{cpre}{output of \link[fnets]{common.predict}}

\item{n.ahead}{forecast horizon}
}
\value{
a list containing
\item{is}{ in-sample estimator of the idiosyncratic component}
\item{fc}{ forecasts of the idiosyncratic component for a given forecasting horizon \code{h}}
\item{n.ahead}{ forecast horizon}
}
\description{
Produces forecasts of the idiosyncratic VAR process
for a given forecasting horizon by estimating the best linear predictors
}
\examples{
\dontrun{
set.seed(123)
n <- 500
p <- 50
common <- sim.unrestricted(n, p)
idio <- sim.var(n, p)
x <- common$data + idio$data
out <- fnets(x,
do.lrpc = FALSE, var.args = list(n.cores = 2))
cpre <- common.predict(out)
ipre <- idio.predict(out, cpre)
}
}
\keyword{internal}
