% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/financials.R
\name{fmpc_financial_dcfv}
\alias{fmpc_financial_dcfv}
\title{Discounted Cash Flow Value}
\usage{
fmpc_financial_dcfv(
  symbols = c("AAPL"),
  period = c("current", "daily", "quarterly", "annually"),
  limit = 100
)
}
\arguments{
\item{symbols}{one or more publicly traded companies domestic or
international}

\item{period}{period for discounted cash flow - current, daily, quarterly,
annually}

\item{limit}{limit the result for each ticker}
}
\value{
data frame of discounted cash flow
}
\description{
Pull Discounted Cash Flow Value for one or more securities
}
\examples{


\dontrun{

# Demo can pull AAPL
fmpc_set_token()
fmpc_financial_dcfv('AAPL')

# For multiple symbols, set a valid API Token
fmpc_set_token('FMPAPIKEY')
fmpc_financial_dcfv(c('AAPL','MSFT','SPY'), period = 'quarterly')

}

}
