% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityMetrics.R
\name{fmpc_security_profile}
\alias{fmpc_security_profile}
\title{Pull profile for a company}
\usage{
fmpc_security_profile(symbols = c("AAPL"))
}
\arguments{
\item{symbols}{one or more symbols from the FMP available list that can be
found using \code{\link{fmpc_symbols_available}}. A valid API token must be
set in order to enable functionality. See documentation for setting a token
under \code{\link{fmpc_set_token}}.}
}
\value{
data frame of descriptive information
}
\description{
Provides pricing, market cap, dividend, company description, CEO, number of
employees, and more for one or more symbols
}
\examples{


\dontrun{

# Demo can pull AAPL
fmpc_set_token()
fmpc_security_profile('AAPL')

# For multiple symbols, set a valid API Token
fmpc_set_token('FMPAPIKEY')
fmpc_security_profile(c('AAPL','MSFT','SPY'))

}

}
