% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callerFunctions.R
\name{callNewtonBFGSLC}
\alias{callNewtonBFGSLC}
\title{Optimize MLE objective for a log-concave density}
\usage{
callNewtonBFGSLC(X, w, params, paramsKernel, cvhParams, gamma = 1000,
  verbose = 0, intEps = 0.001, objEps = 1e-07, offset = 0.1,
  maxIter = 10000)
}
\arguments{
\item{X}{Set of data points (one sample per row)}

\item{w}{Vector of sample weights}

\item{params}{Vector of initial hyperplane parameters}

\item{paramsKernel}{Alternative vector of initial hyperplane parameters}

\item{cvhParams}{List that contains parametrization of the
convex hull of X in terms of its faces}

\item{gamma}{Parameters that governs the smoothness of the log-concave
density (default: 1000)}

\item{verbose}{The amount of information printed during the optimization;
valid levels are {0,1,2} (default: 0)}

\item{intEps}{Threshold of the numerical integration error below which the
optimization may terminite (default: 1e-3)}

\item{objEps}{Threshold of the size of the function step taken below which
the optimziation may terminite (default: 1e-7)}

\item{offset}{Threshold that governs how fast inactive hyperplanes are dropped;
smaller values correspond to a slower rate of hyperplane deletion
(default: 1e-1)}

\item{maxIter}{Maximual number of iterations of Newton optimization (default: 1e4)}
}
\value{
List of n hyperplanes that describe the upper convex hull of log(f(x))
  \item{a}{Slopes of hyerplanes (n x d matrix)}
  \item{b}{Offsets of hyperplanes}
}
\description{
\code{callNewtonBFGSLC} executes the quasi-Newton
  optimization of the maximum likelihood estimator for a log-concave
  density f(x). Calls a underlying C function.
}
