% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crs.R
\name{fm_crs}
\alias{fm_crs}
\alias{fm_crs_oblique}
\alias{st_crs.fm_crs}
\alias{$.fm_crs}
\alias{fm_crs.default}
\alias{fm_crs.crs}
\alias{fm_crs.fm_crs}
\alias{fm_crs.fm_CRS}
\alias{fm_crs.character}
\alias{fm_crs.Spatial}
\alias{fm_crs.SpatVector}
\alias{fm_crs.SpatRaster}
\alias{fm_crs.sf}
\alias{fm_crs.sfc}
\alias{fm_crs.sfg}
\alias{fm_crs.fm_mesh_2d}
\alias{fm_crs.fm_mesh_1d}
\alias{fm_crs.fm_mesh_3d}
\alias{fm_crs.fm_lattice_2d}
\alias{fm_crs.fm_segm}
\alias{fm_crs.fm_list}
\alias{fm_crs.matrix}
\alias{fm_CRS.fm_list}
\alias{fm_wkt_predef}
\alias{fm_crs.inla.CRS}
\title{Obtain coordinate reference system object}
\usage{
fm_crs(x, oblique = NULL, ..., crsonly = deprecated())

fm_crs_oblique(x)

\method{st_crs}{fm_crs}(x, ...)

\method{$}{fm_crs}(x, name)

\method{fm_crs}{default}(x, oblique = NULL, ...)

\method{fm_crs}{crs}(x, oblique = NULL, ...)

\method{fm_crs}{fm_crs}(x, oblique = NULL, ...)

\method{fm_crs}{fm_CRS}(x, oblique = NULL, ...)

\method{fm_crs}{character}(x, oblique = NULL, ...)

\method{fm_crs}{Spatial}(x, oblique = NULL, ...)

\method{fm_crs}{SpatVector}(x, oblique = NULL, ...)

\method{fm_crs}{SpatRaster}(x, oblique = NULL, ...)

\method{fm_crs}{sf}(x, oblique = NULL, ...)

\method{fm_crs}{sfc}(x, oblique = NULL, ...)

\method{fm_crs}{sfg}(x, oblique = NULL, ...)

\method{fm_crs}{fm_mesh_2d}(x, oblique = NULL, ...)

\method{fm_crs}{fm_mesh_1d}(x, oblique = NULL, ...)

\method{fm_crs}{fm_mesh_3d}(x, oblique = NULL, ...)

\method{fm_crs}{fm_lattice_2d}(x, oblique = NULL, ...)

\method{fm_crs}{fm_segm}(x, oblique = NULL, ...)

\method{fm_crs}{fm_list}(x, oblique = NULL, ...)

\method{fm_crs}{matrix}(x, oblique = NULL, ...)

\method{fm_CRS}{fm_list}(x, oblique = NULL, ...)

fm_wkt_predef()

\method{fm_crs}{inla.CRS}(x, oblique = NULL, ...)
}
\arguments{
\item{x}{Object to convert to \code{crs} or  to extract \code{crs} information from.
If \code{character}, a string suitable for \code{sf::st_crs(x)}, or the name of a
predefined \code{wkt} string from ``names(fm_wkt_predef())`.}

\item{oblique}{Numeric vector of length at most 4 of rotation angles (in
degrees) for an oblique projection, all values defaulting to zero. The
values indicate (longitude, latitude, orientation, orbit), as explained in
the Details section below. When \code{oblique} is non-NULL, used to override the
obliqueness parameters of a \code{fm_crs} object. When \code{NA}, remove obliqueness
from the object, resulting in a return class of \code{sf::st_crs()}. When
\code{NULL}, pass though any oblique information in the object, returning an
\code{fm_crs()} object if needed.}

\item{\dots}{Additional parameters. Not currently in use.}

\item{crsonly}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} logical;
if TRUE, remove \code{oblique} information from \code{fm_crs}
objects and return a plain \code{crs} object instead. For \code{crsonly = TRUE}, use
\code{oblique = NA} instead. For \code{crsonly = FALSE}, use default, NULL, or non-NA
\code{oblique}.}

\item{name}{element name}
}
\value{
Either an \code{sf::crs} object or an \code{fm_crs} object,
depending on if the coordinate reference system described by the parameters
can be expressed with a pure \code{crs} object or not.

A \code{crs} object (\code{\link[sf:st_crs]{sf::st_crs()}}) or a \code{fm_crs} object.
An S3 \code{fm_crs} object is a list with elements \code{crs} and \code{oblique}.

\code{fm_wkt_predef} returns a WKT2 string defining a projection
}
\description{
Obtain an \code{sf::crs} or \code{fm_crs} object from a spatial object, or
convert crs information to construct a new \code{sf::crs} object.
}
\details{
The first two
elements of the \code{oblique} vector are the (longitude, latitude)
coordinates for the oblique centre point. The third value (orientation) is a
counter-clockwise rotation angle for an observer looking at the centre point
from outside the sphere. The fourth value is the quasi-longitude (orbit
angle) for a rotation along the oblique observers equator.

Simple oblique: \code{oblique=c(0, 45)}

Polar: \code{oblique=c(0, 90)}

Quasi-transversal: \code{oblique=c(0, 0, 90)}

Satellite orbit viewpoint: \code{oblique=c(lon0-time*v1, 0, orbitangle, orbit0+time*v2)}, where \code{lon0} is the longitude at which a satellite
orbit crosses the equator at \code{time=0}, when the satellite is at an
angle \code{orbit0} further along in its orbit.  The orbital angle relative
to the equatorial plane is \code{orbitangle}, and \code{v1} and \code{v2}
are the angular velocities of the planet and the satellite, respectively.
Note that "forward" from the satellite's point of view is "to the right" in
the projection.

When \code{oblique[2]} or \code{oblique[3]} are non-zero, the resulting
projection is only correct for perfect spheres.
}
\section{Methods (by class)}{
\itemize{
\item \code{fm_crs(fm_list)}: returns a list of 'crs' objects, one for each list element

}}
\section{Methods (by generic)}{
\itemize{
\item \code{st_crs(fm_crs)}: \code{st_crs(x, ...)} is equivalent to
\verb{fm_crs(x, ... oblique = NA)}
when \code{x} is a \code{fm_crs} object.

\item \code{$}: For a \code{fm_crs} object \code{x}, \code{x$name} calls the accessor
method for the \code{crs} object inside it. If \code{name} is "crs", the internal crs
object itself is returned. If \code{name} is "oblique", the internal oblique
angle parameter vector is returned.

}}
\section{Functions}{
\itemize{
\item \code{fm_crs_oblique()}: Return \code{NA} for object with no oblique information,
and otherwise a length 4 numeric vector.

\item \code{fm_CRS(fm_list)}: returns a list of 'CRS' objects, one for each list element

}}
\examples{
crs1 <- fm_crs("longlat_globe")
crs2 <- fm_crs("lambert_globe")
crs3 <- fm_crs("mollweide_norm")
crs4 <- fm_crs("hammer_globe")
crs5 <- fm_crs("sphere")
crs6 <- fm_crs("globe")
names(fm_wkt_predef())
}
\seealso{
\code{\link[sf:st_crs]{sf::st_crs()}}, \code{\link{fm_crs_wkt}}

fm_crs_is_null

\code{\link[=fm_crs<-]{fm_crs<-()}}, \code{\link[=fm_crs_oblique<-]{fm_crs_oblique<-()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
