% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bary.R
\name{fm_bary_simplex}
\alias{fm_bary_simplex}
\alias{fm_bary_simplex.fm_mesh_2d}
\alias{fm_bary_simplex.fm_mesh_3d}
\alias{fm_bary_simplex.fm_mesh_1d}
\alias{fm_bary_simplex.fm_lattice_2d}
\alias{fm_bary_simplex.fm_lattice_Nd}
\title{Extract Simplex information for Barycentric coordinates}
\usage{
fm_bary_simplex(mesh, bary = NULL, ...)

\method{fm_bary_simplex}{fm_mesh_2d}(mesh, bary = NULL, ...)

\method{fm_bary_simplex}{fm_mesh_3d}(mesh, bary = NULL, ...)

\method{fm_bary_simplex}{fm_mesh_1d}(mesh, bary = NULL, ...)

\method{fm_bary_simplex}{fm_lattice_2d}(mesh, bary = NULL, ...)

\method{fm_bary_simplex}{fm_lattice_Nd}(mesh, bary = NULL, ...)
}
\arguments{
\item{mesh}{A mesh object, e.g. \link{fm_mesh_2d} or \link{fm_mesh_1d}.}

\item{bary}{An \link{fm_bary} object. If NULL, return the full simplex
information for the mesh.}

\item{\dots}{Further arguments potentially used by sub-methods.}
}
\value{
A matrix of vertex indices, one row per point in \code{bary}.
}
\description{
Extract the simplex vertex information for a combination of a mesh
and \link{fm_bary} coordinates.
}
\section{Methods (by class)}{
\itemize{
\item \code{fm_bary_simplex(fm_mesh_2d)}: Extract the triangle vertex indices for a 2D mesh

\item \code{fm_bary_simplex(fm_mesh_3d)}: Extract the tetrahedron vertex indices for a 3D
mesh

\item \code{fm_bary_simplex(fm_mesh_1d)}: Extract the edge vertex indices for a 1D mesh

\item \code{fm_bary_simplex(fm_lattice_2d)}: Extract the cell vertex indices for a 2D lattice

\item \code{fm_bary_simplex(fm_lattice_Nd)}: Extract the cell vertex indices for a ND lattice

}}
\examples{
bary <- fm_bary(fmexample$mesh, fmexample$loc_sf)
fm_bary_simplex(fmexample$mesh, bary)
mesh1 <- fm_mesh_1d(1:4)
(bary1 <- fm_bary(mesh1, seq(0, 5, by = 0.5)))
(bary1 <- fm_bary(mesh1, seq(0, 5, by = 0.5), restricted = TRUE))
fm_bary_simplex(mesh1, bary1)
m <- fm_lattice_2d(x = 1:3, y = 1:4)
bary <- fm_bary(m, cbind(1.5, 3.2))
fm_bary_simplex(m, bary)
m <- fm_lattice_Nd(list(x = 1:3, y = 1:4, z = 1:2))
(bary <- fm_bary(m, cbind(1.5, 3.2, 1.5)))
(fm_bary_simplex(m, bary))
fm_bary_loc(m, bary)
}
\seealso{
\code{\link[=fm_bary]{fm_bary()}}, \code{\link[=fm_bary_loc]{fm_bary_loc()}}
}
