% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Predictor.R
\name{Predictor}
\alias{Predictor}
\title{R6 Class representing a predictor}
\description{
This is the abstract superclass for predictor objects like \link{PredictorMLR3} and \link{PredictorCaret}.
A Predictor contains information about an ML model's prediction function and training data.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{model}}{The (trained) model, with the ability to predict on new data.}

\item{\code{X}}{A data.table with feature and target variables.}

\item{\code{feature.names}}{A character vector with the names of the features in X.}

\item{\code{feature.types}}{A character vector with the types (numerical or categorical) of the features in X.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Predictor-new}{\code{Predictor$new()}}
\item \href{#method-Predictor-clone}{\code{Predictor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Predictor-new"></a>}}
\if{latex}{\out{\hypertarget{method-Predictor-new}{}}}
\subsection{Method \code{new()}}{
Create a Predictor object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Predictor$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Predictor cannot be initialized, only its subclasses}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Predictor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Predictor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Predictor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
