% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currency-pair-class.R, R/generic-methods.R,
%   R/indices-class.R
\name{iso.CurrencyPair}
\alias{iso.CurrencyPair}
\alias{iso}
\alias{iso.default}
\alias{iso.IborIndex}
\alias{iso.CashIndex}
\title{Get ISO}
\usage{
\method{iso}{CurrencyPair}(x)

iso(x)

\method{iso}{default}(x)

\method{iso}{IborIndex}(x)

\method{iso}{CashIndex}(x)
}
\arguments{
\item{x}{object from which to extract an ISO}
}
\value{
a string of the ISO
}
\description{
The default method assumes the ISO can be accessed as if it were an attribute
with name \code{iso} (e.g. \code{x$iso}). The method for \code{CurrencyPair} concatenates
the ISOs of the constituent currencies (e.g. \code{iso(AUDUSD())} returns
"AUDUSD") while the methods for \code{CashIndex} and \code{IborIndex} return the ISO of
the index's currency.
}
\examples{
library("lubridate")
iso(AUD())
iso(AUDUSD())
iso(AUDBBSW(months(3)))
iso(AONIA())
}
