% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_st.R
\name{export_st}
\alias{export_st}
\title{Write geojson and geopkgs}
\usage{
export_st(x, file, FUN = sf::write_sf,
  data_source = flyio_get_datasource(),
  bucket = flyio_get_bucket(data_source), dir = flyio_get_dir(),
  delete_file = TRUE, show_progress = FALSE, ...)
}
\arguments{
\item{x}{variable name}

\item{file}{path of the file to be written to}

\item{FUN}{the function using which the file is to write}

\item{data_source}{the name of the data source, if not set globally. s3, gcs or local}

\item{bucket}{the name of the bucket, if not set globally}

\item{dir}{the directory to store intermediate files}

\item{delete_file}{logical. to delete the file to be uploaded}

\item{show_progress}{logical. Shows the progress of the upload operation}

\item{...}{other parameters for the FUN function defined above}
}
\value{
No output
}
\description{
Write geojson and geopkgs
}
\examples{
\dontrun{
# for data on cloud
flyio_set_datasource("gcs")
flyio_set_bucket("your-bucket-name")
export_table(iris, "iris.geojson", dir = tempdir())
}
}
