% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fc_merge.R
\name{fc_merge}
\alias{fc_merge}
\title{fc_merge}
\usage{
fc_merge(fcs)
}
\arguments{
\item{fcs}{list with all the flowcharts that we want to merge}
}
\value{
List containing a list with the datasets belonging to each flowchart and another list with each of the flowcharts parameters to merge.
}
\description{
This function allows to combine horizontally two different flowcharts.
}
\examples{
#Create first flowchart for patients
fc1 <- clinic_patient |>
  dplyr::filter(!is.na(group)) |>
  as_fc(label = "Patients included") |>
  fc_split(group)

#Create second flowchart for visits
fc2 <- clinic_visit |>
  dplyr::filter(!is.na(group)) |>
  as_fc(label = "Number of visits") |>
  fc_split(group)

list(fc1, fc2) |>
  fc_merge() |>
  fc_draw()

}
